/**
* \file: device_handler.c
*
* \version: $Id:$
*
* \release: $Name:$
*
* \component: automounter
*
* \author: Marko Hoyer / ADIT / SWGII / mhoyer@de.adit-jv.com
*
* \copyright (c) 2010, 2011 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
*
***********************************************************************/
#include <stdlib.h>

#include "backends/device_handler.h"

#include "control/watch.h"
#include "backends/msd.h"

const devicehandler_vtable_t *device_handler_list[]=
{
		&msd_handler_vtable,
		NULL
};


error_code_t device_handler_init_all(void)
{
	int itr;
	error_code_t result=RESULT_OK;

	for (itr=0;device_handler_list[itr]!=NULL && result==RESULT_OK;itr++)
	{
		if (device_handler_list[itr]->init!=NULL)
			result=device_handler_list[itr]->init();
	}

	return result;
}

void device_handler_deinit_all(void)
{
	int itr;

	for (itr=0;device_handler_list[itr]!=NULL;itr++)
	{
		if (device_handler_list[itr]->deinit!=NULL)
			device_handler_list[itr]->deinit();
	}
}

error_code_t device_handler_blacklist_mounted_device_all(const char* mount_src)
{
	int itr;
	error_code_t result=RESULT_OK;

	for (itr=0;device_handler_list[itr]!=NULL && result==RESULT_OK;itr++)
	{
		if (device_handler_list[itr]->blacklist_mounted_device!=NULL)
			result=device_handler_list[itr]->blacklist_mounted_device(mount_src);
	}

	return result;
}

error_code_t device_handler_add_event_source(watch_t *watch, uint32_t event_mask)
{
	return watch_add_event_source(watch, event_mask);
}

error_code_t device_handler_remove_event_source(watch_t *watch)
{
	return watch_remove_event_source(watch);
}
